<?php
// config.php (should be a separate file)
include 'config.php';

// Handle POST request for gold prices
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate and sanitize input
    $gold18 = filter_input(INPUT_POST, 'gold18', FILTER_VALIDATE_FLOAT);
    $gold21 = filter_input(INPUT_POST, 'gold21', FILTER_VALIDATE_FLOAT);
    $gold24 = filter_input(INPUT_POST, 'gold24', FILTER_VALIDATE_FLOAT);
    $ounce = filter_input(INPUT_POST, 'ounce', FILTER_VALIDATE_FLOAT);
    $silver = filter_input(INPUT_POST, 'silver', FILTER_VALIDATE_FLOAT);

    if ($gold18 === false || $gold21 === false || $gold24 === false || 
        $ounce === false || $silver === false) {
        http_response_code(400);
        echo "error: Invalid input data";
        exit;
    }

    // Prepare and execute SQL
    $sql = "INSERT INTO gold_prices (gold18, gold21, gold24, ounce, silver) VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    
    if (!$stmt) {
        http_response_code(500);
        echo "error: " . $conn->error;
        exit;
    }

    $stmt->bind_param("ddddd", $gold18, $gold21, $gold24, $ounce, $silver);

    if ($stmt->execute()) {
        echo "success";
    } else {
        http_response_code(500);
        echo "error: " . $stmt->error;
    }

    $stmt->close();
}

$conn->close();
?>